# NODA-Dreamer

This repository implements the main algorithm of NODA-Dreamer and NODA-BIRD described in "Model-based Reinforcement Learning with a Hamiltonian Canonical ODE-Inspired Network". The implementation is done by combining an ODE network with Dreamer and BIRD by replacing their transition models.

**NOTE:** Check out the code for [Dreamer](https://github.com/danijar/dreamer) and [BIRD](https://github.com/Mehooz/BIRD_code), which we mainly build our NODA-Dreamer and NODA-BIRD on respectively.

## Requirements

To configure your (virtual) environment(python 3.8 recommended), run the following command:
```
$ pip install -r requirements.txt
```
What's more, download [tfdiffeq](https://github.com/titu1994/tfdiffeq), and run the following command in the root directory:
```
$ python setup.py install
```

## Instructions

To train the agent using [Dreamer](https://github.com/danijar/dreamer), go to `Code/Dreamer`, and run:
```
$ python dreamer.py --logdir ./logdir/Dreamer/dmc_walker_walk/seed_0 --task dmc_walker_walk --cuda_idx 0
```
To train the agent using [BIRD](https://github.com/Mehooz/BIRD_code), go to `Code/BIRD`, and run:
```
$ python bird.py --logdir ./logdir/BIRD/dmc_walker_walk/seed_0 --task dmc_walker_walk --device 0
```
To train the agent using NODA-Dreamer, go to `Code/NODA-Dreamer`, and run:
```
$ python noda-dreamer.py --logdir ./logdir/NODA-Dreamer/dmc_walker_walk/seed_0 --task dmc_walker_walk --cuda_idx 0
```
To train the agent using NODA-BIRD, go to `Code/NODA-BIRD`, and run:
```
$ python noda-bird.py --logdir ./logdir/NODA-BIRD/dmc_walker_walk/seed_0 --task dmc_walker_walk --device 0
```
To evaluate the agents under 4 algorithms, we provide a code in `Code/plotting.py` and some example data in `example_data/`. We got the example data of each algorithm by extracting only the test returns in the metrics.jsonl of every training run. To run the code:
```
$ python plotting.py --task dmc_walker_walk --noda_dreamer_dir NODA-Dreamer --noda_bird_dir NODA-BIRD --dreamer_dir Dreamer --bird_dir BIRD
```
